import webbrowser

import bpy
from bpy.types import Context


class OpenWebsite(bpy.types.Operator):
    bl_idname: str = "mb.info_marionette"
    bl_label: str = "Website"
    bl_description: str = "Opens the Marionette website in the browser"
    bl_options: set[str] = {"INTERNAL"}

    def execute(self, context: Context) -> set[str]:
        webbrowser.open("https://marionettexr.com/")
        self.report({"INFO"}, "Opened Marionette website.")
        return {"FINISHED"}
