import os
import pathlib
from enum import Enum
from typing import cast

import bpy.utils.previews
from bpy.utils.previews import ImagePreviewCollection

icons: ImagePreviewCollection | None = None


class Icons(Enum):
    LOGO = "LOGO"

    def get_icon(self) -> int:
        assert icons is not None
        return cast(int, icons.get(self.value).icon_id)


def load_icons() -> None:
    main_dir = pathlib.Path(os.path.dirname(__file__)).parent.resolve()
    resources_dir = os.path.join(str(main_dir), "resources")
    icons_dir = os.path.join(resources_dir, "icons")

    global icons
    icons = bpy.utils.previews.new()
    icons.load("LOGO", os.path.join(icons_dir, "marionettex.png"), "IMAGE")


def unload_icons() -> None:
    global icons
    if icons:
        bpy.utils.previews.remove(icons)
