import sys


def unload_packages(packages):
    # construct unload list
    unload_list = []
    for i in sys.modules.keys():
        for package in packages:
            if i.startswith(package):
                unload_list.append(i)

    # unload everything
    for i in unload_list:
        try:
            if sys.modules[i] is not None:
                del sys.modules[i]
                print(f'Unloaded {i}.')
        except Exception as e:
            print(f'Failed to unload {i}: {e}')


if __name__ == "__main__":
    unload_packages(packages=['marionette'])
    import marionette
