import time


class Stopwatch:
    def __init__(self, name: str) -> None:
        self.name = name

    def __enter__(self) -> None:
        self.start = time.perf_counter()

    def __exit__(self, *args) -> None:
        print(self.name, (time.perf_counter() - self.start) * 1000, 'ms')
