from maya import cmds


class ProgressWindow:
    title: str
    status: str
    is_interruptable: bool

    def __init__(self, title: str, status: str, is_interruptable: bool) -> None:
        self.title = title
        self.status = status
        self.is_interruptable = is_interruptable

    def __enter__(self) -> 'ProgressWindow':
        cmds.progressWindow(title=self.title,
                            progress=0,
                            status=self.status,
                            isInterruptable=self.is_interruptable)
        return self

    def has_been_cancelled(self) -> bool:
        if self.is_interruptable:
            return cmds.progressWindow(query=True, isCancelled=True)
        else:
            return False

    def report(self, status: str, progress: float) -> None:
        cmds.progressWindow(edit=True, progress=progress, status=status)

    def __exit__(self, typ, val, tb) -> None:
        cmds.progressWindow(endProgress=1)
