from maya import cmds


class UndoChunk:
    def __init__(self, name=None) -> None:
        self.name = name

    def __enter__(self) -> None:
        if self.name is not None:
            cmds.undoInfo(openChunk=True, chunkName=self.name)
        else:
            cmds.undoInfo(openChunk=True)

    def __exit__(self, typ, val, tb) -> None:
        cmds.undoInfo(closeChunk=True)
